//+------------------------------------------------------------------+
//|                                                      C_Mouse.mqh |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include "C_Terminal.mqh"
//+------------------------------------------------------------------+
#define def_PrefixNameObject	"MOUSE_"
#define def_MouseLineName		def_PrefixNameObject + "H"
#define def_MouseLineTake		def_PrefixNameObject + "T"
#define def_MouseLineStop		def_PrefixNameObject + "S"
//+------------------------------------------------------------------+
#define def_BtnLeftClick(A)	((A & 0x01) == 0x01)
#define def_SHIFT_Press(A)		((A & 0x04) == 0x04)
#define def_CTRL_Press(A)		((A & 0x08) == 0x08)
//+------------------------------------------------------------------+
class C_Mouse : private C_Terminal
{
	private	:
		struct st00
		{
			long 		Id;
			color		CorPrice,
						CorTake,
						CorStop;
			double	Price,
						PointsStop,
						PointsTake;
			uint		BtnStatus;
		}m_Infos;
//+------------------------------------------------------------------+
		void CreateLineH(const string szName, const color cor)
			{
 				ObjectCreate(m_Infos.Id, szName, OBJ_HLINE, 0, 0, 0);
 				ObjectSetString(m_Infos.Id, szName, OBJPROP_TOOLTIP, "\n");
 				ObjectSetInteger(m_Infos.Id, szName, OBJPROP_BACK, false);
 				ObjectSetInteger(m_Infos.Id, szName, OBJPROP_COLOR, cor);
			}
//+------------------------------------------------------------------+
	public	:
//+------------------------------------------------------------------+
		C_Mouse(const color corPrice, const color corTake, const color corStop, const double FinanceStop, const double FinanceTake, const uint Leverage)
			{
				m_Infos.Id = ChartID();
				m_Infos.CorPrice 	= corPrice;
				m_Infos.CorTake	= corTake;
				m_Infos.CorStop	= corStop;
				m_Infos.PointsTake= FinanceToPoints(FinanceTake, Leverage);
				m_Infos.PointsStop= FinanceToPoints(FinanceStop, Leverage);
				ChartSetInteger(m_Infos.Id, CHART_EVENT_MOUSE_MOVE, true);
				ChartSetInteger(m_Infos.Id, CHART_EVENT_OBJECT_DELETE, true);
				CreateLineH(def_MouseLineName, m_Infos.CorPrice);
				ChartSetInteger(m_Infos.Id, CHART_COLOR_VOLUME, corPrice);
				ChartSetInteger(m_Infos.Id, CHART_COLOR_STOP_LEVEL, corStop);
			}
//+------------------------------------------------------------------+	
		~C_Mouse()
			{
				ChartSetInteger(m_Infos.Id, CHART_EVENT_OBJECT_DELETE, false);
				ObjectsDeleteAll(m_Infos.Id, def_PrefixNameObject);
			}
//+------------------------------------------------------------------+	
const void GetStatus(double &Price, uint &BtnStatus) const
			{
				Price = m_Infos.Price;
				BtnStatus = m_Infos.BtnStatus;
			}
//+------------------------------------------------------------------+	
		void DispatchMessage(const int id, const long &lparam, const double &dparam, const string &sparam)
			{
				int w;
				datetime dt;
				static bool bView = false;
				
				switch (id)
					{
						case CHARTEVENT_OBJECT_DELETE:
							if (sparam == def_MouseLineName) CreateLineH(def_MouseLineName, m_Infos.CorPrice);
							break;
						case CHARTEVENT_MOUSE_MOVE:
							ChartXYToTimePrice(m_Infos.Id, (int)lparam, (int)dparam, w, dt, m_Infos.Price);
							ObjectMove(m_Infos.Id, def_MouseLineName, 0, 0, m_Infos.Price = AdjustPrice(m_Infos.Price));
							m_Infos.BtnStatus = (uint)sparam;
							if (def_CTRL_Press(m_Infos.BtnStatus) != def_SHIFT_Press(m_Infos.BtnStatus))
							{
								if (!bView)
								{
									if (m_Infos.PointsTake > 0) CreateLineH(def_MouseLineTake, m_Infos.CorTake);
									if (m_Infos.PointsStop > 0) CreateLineH(def_MouseLineStop, m_Infos.CorStop);
									bView = true;
								}
								if (m_Infos.PointsTake > 0) ObjectMove(m_Infos.Id, def_MouseLineTake, 0, 0, m_Infos.Price + (m_Infos.PointsTake * (def_SHIFT_Press(m_Infos.BtnStatus) ? 1 : -1)));
								if (m_Infos.PointsStop > 0) ObjectMove(m_Infos.Id, def_MouseLineStop, 0, 0, m_Infos.Price + (m_Infos.PointsStop * (def_SHIFT_Press(m_Infos.BtnStatus) ? -1 : 1)));
							}else if (bView)
							{
								ObjectsDeleteAll(m_Infos.Id, def_PrefixNameObject);
								bView = false;
							}
							ChartRedraw();
							break;
					}
			}
//+------------------------------------------------------------------+	
};
//+------------------------------------------------------------------+
#undef def_MouseLineName
#undef def_MouseLineStop
#undef def_MouseLineTake
#undef def_PrefixNameObject
//+------------------------------------------------------------------+
